from django.contrib import admin
from .models import BoardMember, AdvisoryMember,VolunteerApplication, InternshipApplication, JobApplication, NewsArticle, Document, ContactMessage, MediaItem, TeamMember, Department

@admin.register(BoardMember)
class BoardMemberAdmin(admin.ModelAdmin):
    list_display = ['name', 'position', 'image']
    
@admin.register(AdvisoryMember)
class AdvisoryMemberAdmin(admin.ModelAdmin):
    list_display = ['name', 'specialization', 'image']
    
@admin.register(TeamMember)
class TeamMemberAdmin(admin.ModelAdmin):
    list_display = ['name', 'position', 'bio', 'email', 'image', 'department', 'is_leadership', 'linkedin_url', 'twitter_url', 'github_url']

@admin.register(Department)
class DepartmentAdmin(admin.ModelAdmin):
    list_display = ['name', 'slug']
    
    
@admin.register(VolunteerApplication)
class VolunteerApplicationAdmin(admin.ModelAdmin):
    list_display = ['name', 'email', 'phone', 'area', 'availability', 'submitted_at']
    
@admin.register(InternshipApplication)
class InternshipApplicationAdmin(admin.ModelAdmin):
    list_display = ['name', 'email', 'education', 'position', 'cv', 'motivation', 'submitted_at']
    
@admin.register(JobApplication)
class JobApplicationAdmin(admin.ModelAdmin):
    list_display = ['name', 'email', 'phone', 'experience', 'resume', 'cover_letter', 'submitted_at']
    
@admin.register(NewsArticle)
class NewsArticleAdmin(admin.ModelAdmin):
    list_display = ['title', 'summary', 'content', 'image', 'created_at', 'updated_at', 'published_at', 'is_published']
    list_filter = ['published_at']
    search_fields = ['title', 'summary']
    ordering = ['-published_at']
    
@admin.register(Document)
class DocumentAdmin(admin.ModelAdmin):
    list_display = ['title', 'file', 'category', 'uploaded_at']
    search_fields = ['title']
    ordering = ['title']

@admin.register(ContactMessage)
class ContactMessageAdmin(admin.ModelAdmin):
    list_display = ['name', 'email', 'subject', 'message', 'created_at']
    search_fields = ['name', 'email', 'subject']
    ordering = ['-created_at']
    list_filter = ['created_at']    
    
@admin.register(MediaItem)
class MediaItemAdmin(admin.ModelAdmin):
    list_display = ['title','description', 'media_type', 'image','video_url', 'created_at']
    search_fields = ['title', 'description']
    list_filter = ['media_type', 'created_at']
    ordering = ['-created_at']
    