from django.urls import path
from .views import AboutView,CareersView, NewsDetailView, HomepageView, ResourcesView, NewsListView,ContactView, MediaPageView, MediaDetailView, EducationView, LivelihoodView, WashView, SocialJusticeView, ClimateView, EcoTourismView,RestorationView, AgribusinessView, FinancialLiteracyView,BoardProfilesView, DownloadBoardProfilesPDF, TeamPageView

urlpatterns = [
    path('', HomepageView.as_view(), name='home'),
    path('about/', AboutView.as_view(), name='about'),
    path('careers/', CareersView.as_view(), name='careers' ),
    path('contact/', ContactView.as_view(), name='contact'),
    path('board-profiles/',BoardProfilesView.as_view(), name='board_profiles'),
    path('board-profiles/download/', DownloadBoardProfilesPDF.as_view(), name='download_board_profiles'),
    path('news/', NewsListView.as_view(), name='news_list'),
    path('news/<int:pk>/', NewsDetailView.as_view(), name='news_detail'),
    path('resources', ResourcesView.as_view(), name='resources'), 
    path('media/', MediaPageView.as_view(), name='media'),
    path('media/<int:pk>/', MediaDetailView.as_view(), name='media_detail'),
    path('resources', ResourcesView.as_view(), name='resources'),
    path('programs/education/', EducationView.as_view(), name='education' ),
    path('programs/livelihood/',LivelihoodView.as_view(), name='livelihood' ),
    path('programs/wash/', WashView.as_view(), name='wash' ),
    path('programs/social-justice/', SocialJusticeView.as_view(), name='social_justice' ),
    path('programs/climate/', ClimateView.as_view(), name='climate' ),
    # Projects
    path('projects/eco-tourism/', EcoTourismView.as_view(), name='eco_tourism' ),
    path('projects/restoration/', RestorationView.as_view(), name='restoration' ),
    path('projects/agri-business/', AgribusinessView.as_view(), name='agribusiness' ),
    path('projects/financial-literacy/', FinancialLiteracyView.as_view(), name='financial_literacy' ),
    
    #Team
    path('team/', TeamPageView.as_view(), name='team' ),

    
]
